using System;
using System.IO;

public class Program
{
  public static void Main(String[] args)
  {
    if(args.Length < 1)
    {
      Console.WriteLine("Wywołanie programu: Program katalog");
      return;
    }
    
    String katalog = args[0];
    DirectoryInfo di;
    
    try{
      di = new DirectoryInfo(katalog);
    }
    catch(ArgumentException)
    {
      Console.WriteLine(
        "Nazwa {0} zawiera nieprawidłowe znaki.", katalog);
      return;
    }

    if(di.Exists)
    {
      Console.WriteLine("Katalog {0} już istnieje", katalog);
      return;
    }

    try
    {
      di.Create();
    }
    catch(IOException)
    {
      Console.WriteLine(
        "Katalog {0} nie może być utworzony.", katalog);
      return;
    }
    Console.WriteLine("Katalog {0} został utworzony.", katalog);
  }
}
